/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockScreen;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.client.JSQueryDispatcher;
import net.montoyo.wd.config.ClientConfig;
import net.montoyo.wd.controls.builtin.ClickControl;
import net.montoyo.wd.core.DefaultUpgrade;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.init.BlockInit;
import net.montoyo.wd.item.WDItem;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.net.server_bound.C2SMessageScreenCtrl;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Multiblock;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3i;

public class ItemLaserPointer
extends Item
implements WDItem {
    private static TileEntityScreen pointedScreen;
    private static BlockSide pointedScreenSide;
    private static long lastPointPacket;
    private static boolean mouseDown;
    private static boolean left;
    private static boolean middle;
    private static boolean right;

    public ItemLaserPointer(Item.Properties properties) {
        super(properties.m_41487_(1).m_41491_((CreativeModeTab)WebDisplays.CREATIVE_TAB));
    }

    public static void tick(Minecraft mc) {
        BlockHitResult result = ClientProxy.raycast(64.0);
        BlockPos bpos = result.m_82425_();
        if (result.m_6662_() == HitResult.Type.BLOCK && mc.f_91073_.m_8055_(bpos).m_60734_() == BlockInit.blockScreen.get()) {
            Vector3i pos = new Vector3i(result.m_82425_());
            BlockSide side = BlockSide.values()[result.m_82434_().ordinal()];
            Multiblock.findOrigin((LevelAccessor)mc.f_91073_, pos, side, null);
            TileEntityScreen te = (TileEntityScreen)mc.f_91073_.m_7702_(pos.toBlock());
            if (te != null && te.hasUpgrade(side, DefaultUpgrade.LASERMOUSE)) {
                TileEntityScreen.Screen scr = te.getScreen(side);
                if (scr.browser != null) {
                    float hitX = (float)result.m_82450_().f_82479_ - (float)pos.x;
                    float hitY = (float)result.m_82450_().f_82480_ - (float)pos.y;
                    float hitZ = (float)result.m_82450_().f_82481_ - (float)pos.z;
                    Vector2i tmp = new Vector2i();
                    if (BlockScreen.hit2pixels(side, bpos, new Vector3i(result.m_82425_()), scr, hitX, hitY, hitZ, tmp)) {
                        ItemLaserPointer.laserClick(te, side, scr, tmp);
                    }
                }
            }
        }
    }

    public static void deselect(Minecraft mc, JSQueryDispatcher jsDispatcher) {
        ItemLaserPointer.deselectScreen();
    }

    private static void laserClick(TileEntityScreen tes, BlockSide side, TileEntityScreen.Screen scr, Vector2i hit) {
        tes.handleMouseEvent(side, ClickControl.ControlType.MOVE, hit, -1);
        if (pointedScreen == tes && pointedScreenSide == side) {
            long t = System.currentTimeMillis();
            if (t - lastPointPacket >= 100L) {
                lastPointPacket = t;
                WDNetworkRegistry.INSTANCE.sendToServer((Object)C2SMessageScreenCtrl.laserMove(tes, side, hit));
            }
        } else {
            ItemLaserPointer.deselectScreen();
            pointedScreen = tes;
            pointedScreenSide = side;
        }
    }

    private static void deselectScreen() {
        if (pointedScreen != null && pointedScreenSide != null) {
            pointedScreen = null;
            pointedScreenSide = null;
        }
    }

    public static void press(boolean press, int button) {
        if (button <= 1 && ClientConfig.switchButtons) {
            button = 1 - button;
        }
        if (button == 0) {
            left = press;
        } else if (button == 1) {
            right = press;
        } else if (button == 2) {
            middle = press;
        }
        Minecraft mc = Minecraft.m_91087_();
        BlockHitResult result = ClientProxy.raycast(64.0);
        Vector3i pos = new Vector3i(result.m_82425_());
        BlockSide side = BlockSide.values()[result.m_82434_().ordinal()];
        Multiblock.findOrigin((LevelAccessor)mc.f_91073_, pos, side, null);
        float hitX = (float)result.m_82450_().f_82479_ - (float)pos.x;
        float hitY = (float)result.m_82450_().f_82480_ - (float)pos.y;
        float hitZ = (float)result.m_82450_().f_82481_ - (float)pos.z;
        Vector2i tmp = new Vector2i();
        BlockEntity be = mc.f_91073_.m_7702_(pos.toBlock());
        if (!(be instanceof TileEntityScreen)) {
            return;
        }
        TileEntityScreen te = (TileEntityScreen)be;
        if (te.hasUpgrade(side, DefaultUpgrade.LASERMOUSE)) {
            TileEntityScreen.Screen scr = te.getScreen(side);
            if (scr.browser != null && BlockScreen.hit2pixels(side, result.m_82425_(), new Vector3i(result.m_82425_()), scr, hitX, hitY, hitZ, tmp)) {
                te.handleMouseEvent(side, ClickControl.ControlType.MOVE, tmp, -1);
                te.handleMouseEvent(side, press ? ClickControl.ControlType.DOWN : ClickControl.ControlType.UP, tmp, button);
                if (press) {
                    WDNetworkRegistry.INSTANCE.sendToServer((Object)C2SMessageScreenCtrl.laserDown(te, side, tmp, button));
                } else {
                    WDNetworkRegistry.INSTANCE.sendToServer((Object)C2SMessageScreenCtrl.laserUp(te, side, button));
                }
            }
        }
    }

    public static boolean isOn() {
        return left || right || middle;
    }

    @Override
    @Nullable
    public String getWikiName(@Nonnull ItemStack is) {
        return is.m_41720_().m_7626_(is).getString();
    }

    static {
        mouseDown = false;
    }
}

